<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use App\Models\User;
use App\Models\Role;

class UserRoleApiTest extends TestCase
{
    use RefreshDatabase;

    public function test_can_get_users_by_role()
    {
        // Create roles
        $superAdminRole = Role::factory()->create(['name' => 'super-admin']);
        $userRole = Role::factory()->create(['name' => 'user']);
        $otherRole = Role::factory()->create(['name' => 'other']);

        // Create users with roles
        User::factory(5)->create(['role_id' => $superAdminRole->id]);
        User::factory(5)->create(['role_id' => $userRole->id]);
        User::factory(5)->create(['role_id' => $otherRole->id]);

        // Test the API endpoint
        $response = $this->get('/api/testusers');

        $response->assertStatus(200);

        $response->assertJsonStructure([
            'super-admins',
            'users',
            'other-roles'
        ]);

        // Assert that the counts are correct (limited to 3)
        $this->assertCount(3, $response->json('super-admins'));
        $this->assertCount(3, $response->json('users'));
        $this->assertCount(3, $response->json('other-roles'));
    }
}
