<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;
use Database\Seeders\GameSeeder;

class GameApiTest extends TestCase
{
    use RefreshDatabase;
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function test_can_get_all_games()
    {
        // Seed the database with games
        $this->seed(GameSeeder::class);

        $response = $this->get('/api/games');

        $response->assertStatus(200);

        $games = $response->json();

        // Optional: Print the games to the console
        print_r($games);
    }
}
