<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\{
    GameController, RoleController, UserRoleController, 
    BookingController, ReportController, PesapalController, 
    PermissionController, AuthController, BackupController,
    SystemController
};

/*
|--------------------------------------------------------------------------
| Public Routes
|--------------------------------------------------------------------------
*/
Route::post('/register', [AuthController::class, 'signup']);
Route::post('/login', [AuthController::class, 'login']);
Route::post('/forgot-password', [AuthController::class, 'forgotPassword']);
Route::post('/reset-password', [AuthController::class, 'resetPassword']);
Route::post('/resend-verification-email', [AuthController::class, 'resendVerificationEmail']);
Route::get('/verify-email', [AuthController::class, 'verifyEmail']);
Route::get('bookings/history/{query}', [BookingController::class, 'getHistory']);

// Payment Callbacks & Status
Route::prefix('pesapal')->group(function () {
    Route::post('/submit-order', [PesapalController::class, 'submitOrder']);
    Route::get('/status/{orderTrackingId}', [PesapalController::class, 'checkStatusByTrackingId']);
    Route::get('/status', [PesapalController::class, 'getTransactionStatus']);
    Route::get('/ipns', [PesapalController::class, 'listIpns']);
    Route::post('/ipn', [PesapalController::class, 'registerIpn']);    
});

/*
|--------------------------------------------------------------------------
| Protected Routes (Authenticated)
|--------------------------------------------------------------------------
*/
Route::middleware('auth:sanctum')->group(function () {
Route::prefix('pesapal')->group(function () {
    // Route::post('/submit-order', [PesapalController::class, 'submitOrder']);
    // Route::get('/status/{orderTrackingId}', [PesapalController::class, 'checkStatusByTrackingId']);
    // Route::get('/status', [PesapalController::class, 'getTransactionStatus']);
    // Route::get('/ipns', [PesapalController::class, 'listIpns']);
    // Route::post('/ipn', [PesapalController::class, 'registerIpn']);    
    Route::post('/refund', [PesapalController::class, 'refundPayment'])->middleware('permission:manage_bookings');
});
    // --- GET REQUESTS (Data Retrieval) ---
    Route::get('/user', function (Request $request) { return $request->user(); });
    
    Route::middleware('permission:view_games')->get('games/count', [GameController::class, 'count']);
    
    Route::middleware('permission:view_bookings')->group(function () {
        Route::get('bookings/count', [BookingController::class, 'count']);
        Route::get('bookings/history', [BookingController::class, 'history']);
    });

    Route::middleware('permission:view_users')->get('users/count', [UserRoleController::class, 'count']);
    
    Route::middleware('permission:manage_roles')->group(function () {
        Route::get('roles/count', [RoleController::class, 'count']);
        Route::get('backups', [BackupController::class, 'backup']);
        Route::post('system/migrate-seed', [SystemController::class, 'migrateAndSeed']);
    });

    Route::get('reports', [ReportController::class, 'index'])->middleware('permission:view_reports');
    Route::get('reports/revenue', [ReportController::class, 'revenueReports'])->middleware('permission:view_reports');
    Route::get('reports/operational', [ReportController::class, 'operationalReports'])->middleware('permission:view_reports');
    Route::get('reports/customer', [ReportController::class, 'customerReports'])->middleware('permission:view_reports');
    Route::get('reports/logistics', [ReportController::class, 'logisticsReports'])->middleware('permission:view_reports');
    Route::get('reports/admin-performance', [ReportController::class, 'adminPerformanceReports'])->middleware('permission:view_reports');
    Route::get('reports/export/csv', [ReportController::class, 'exportCsv'])->middleware('permission:view_reports');
  
    // Dashboard Analytics APIs
    Route::get('dashboard/kpis', [BookingController::class, 'kpis'])->middleware('permission:view_bookings');
    Route::get('dashboard/game-analytics', [BookingController::class, 'gameAnalytics'])->middleware('permission:view_bookings');
    Route::get('dashboard/financial-insights', [BookingController::class, 'financialInsights'])->middleware('permission:view_bookings');
    Route::get('dashboard/time-trends', [BookingController::class, 'timeTrends'])->middleware('permission:view_bookings');
    Route::get('dashboard/operational', [BookingController::class, 'operationalDetails'])->middleware('permission:view_bookings');
    Route::get('dashboard/alerts', [BookingController::class, 'alerts'])->middleware('permission:view_bookings');

    // --- POST REQUESTS (Creation) ---
    Route::post('backups', [BackupController::class, 'create'])->middleware('permission:manage_roles');

    // --- PUT/PATCH REQUESTS (Updates) ---
    Route::put('roles/{role}/permissions', [RoleController::class, 'updatePermissions'])->middleware('permission:manage_roles');
// Custom route for admitting by ticketId (Place this ABOVE the resource)
Route::patch('bookings/{ticketId}', [BookingController::class, 'admit'])
    ->middleware('permission:view_bookings');
    // --- RESOURCE ROUTES ---
    // These handle GET, POST, PUT, and DELETE automatically
    Route::apiResource('games', GameController::class)->middleware('permission:view_games');
     Route::apiResource('bookings', BookingController::class)->middleware('permission:view_bookings');
    Route::apiResource('users', UserRoleController::class)->middleware('permission:view_users');
    Route::apiResource('roles', RoleController::class)->middleware('permission:manage_roles');
    Route::apiResource('permissions', PermissionController::class)->middleware('permission:manage_roles');
});

  Route::get('reports/export/pdf', [ReportController::class, 'exportPdf']);
// Route for admitting a booking via ticketId
// Route::patch('bookings/{ticketId}', [BookingController::class, 'admit']);
Route::get('games', [GameController::class, 'index']);
Route::get('games/{game}', [GameController::class, 'show']);

        Route::get('system/migrate-seed', [SystemController::class, 'migrateAndSeed']);