<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Role;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('roles')->truncate();
        DB::table('permission_role')->truncate();

        $roles = [
            [
                'name' => 'Super Admin',
                'permissions' => DB::table('permissions')->pluck('id')->toArray(),
            ],
            [
                'name' => 'Admin',
                'permissions' => DB::table('permissions')->whereIn('name', ['validate_ticket', 'manage_bookings', 'view_financials', 'manage_games'])->pluck('id')->toArray(),
            ],
            [
                'name' => 'Manager',
                'permissions' => DB::table('permissions')->whereIn('name', ['validate_ticket', 'manage_bookings', 'view_financials'])->pluck('id')->toArray(),
            ],
            [
                'name' => 'Ticket Validator',
                'permissions' => DB::table('permissions')->whereIn('name', ['validate_ticket'])->pluck('id')->toArray(),
            ],
            [
                'name' => 'User',
                'permissions' => [],
            ]
        ];

        foreach ($roles as $roleData) {
            $role = Role::create(['name' => $roleData['name']]);
            $role->permissions()->attach($roleData['permissions']);
        }
    }
}
