<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('permissions')->truncate();

        $permissions = [
            ['name' => 'view_dashboard'],
            ['name' => 'view_bookings'],
            ['name' => 'manage_bookings'],
            ['name' => 'view_games'],
            ['name' => 'edit_games'],
            ['name' => 'create_games'],
            ['name' => 'delete_games'],
            ['name' => 'view_schedule'],
            ['name' => 'create_admin_booking'],
            ['name' => 'view_reports'],
            ['name' => 'use_ai_forecast'],
            ['name' => 'view_users'],
            ['name' => 'manage_users'],
            ['name' => 'view_admin_management'],
            ['name' => 'create_admin'],
            ['name' => 'edit_admin_role'],
            ['name' => 'delete_admin'],
            ['name' => 'view_admin_performance'],
            ['name' => 'validate_ticket'],
            ['name' => 'manage_roles'],
            ['name' => 'view_financials'],
        ];

        DB::table('permissions')->insert($permissions);
    }
}
