<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GameSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $games = [
            [
                'name' => 'Bowling',
                'image_id' => 2,
                'category' => 'Standard',
                'description' => 'Classic bowling alley with 10 lanes. Perfect for parties and casual fun.',
                'price' => 1500,
                'capacity' => 60,
                'status' => 'Open',
                'minPlayers' => 2,
                'maxPlayers' => 6,
                'onPremisesOnly' => false,
                'options' => json_encode([
                    [
                        'id' => 'players',
                        'label' => 'Number of Players',
                        'type' => 'quantity',
                        'pricePerUnit' => 1500
                    ],
                ]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'VR World',
                'image_id' => 3,
                'category' => 'Premium',
                'description' => 'Explore new realities with our state-of-the-art VR setups.',
                'price' => 2500,
                'capacity' => 10,
                'status' => 'Open',
                'minPlayers' => 1,
                'maxPlayers' => 4,
                'onPremisesOnly' => true,
                'options' => json_encode([
                    [
                        'id' => 'session_time',
                        'label' => 'Session Time',
                        'type' => 'select',
                        'values' => [
                            ['id' => '30min', 'label' => '30 Minutes', 'price' => 2500],
                            ['id' => '60min', 'label' => '1 Hour', 'price' => 4000],
                        ]
                    ],
                ]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Mini Golf',
                'image_id' => 4,
                'category' => 'Standard',
                'description' => 'A whimsical 9-hole mini-golf course under the stars.',
                'price' => 1000,
                'capacity' => 36,
                'status' => 'Open',
                'minPlayers' => 1,
                'maxPlayers' => 4,
                'onPremisesOnly' => false,
                'options' => json_encode([]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Go-Kart Racing',
                'image_id' => 5,
                'category' => 'Premium',
                'description' => 'Race against your friends on our thrilling indoor go-kart track.',
                'price' => 3000,
                'capacity' => 12,
                'status' => 'Closed',
                'minPlayers' => 4,
                'maxPlayers' => 12,
                'onPremisesOnly' => false,
                'options' => json_encode([
                     [
                        'id' => 'race_laps',
                        'label' => 'Race Laps',
                        'type' => 'select',
                        'values' => [
                            ['id' => '10laps', 'label' => '10 Laps', 'price' => 3000],
                            ['id' => '20laps', 'label' => '20 Laps', 'price' => 5000],
                        ]
                    ],
                ]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Pool Table',
                'image_id' => 6,
                'category' => 'Standard',
                'description' => 'Classic 8-ball pool tables available for hourly rental.',
                'price' => 500,
                'capacity' => 8,
                'status' => 'Open',
                'minPlayers' => 2,
                'maxPlayers' => 2,
                'onPremisesOnly' => true,
                'options' => json_encode([
                    [
                        'id' => 'rental_time',
                        'label' => 'Rental Time',
                        'type' => 'quantity',
                        'pricePerUnit' => 500
                    ],
                ]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
             [
                'name' => 'Paddle Tennis',
                'image_id' => 7,
                'category' => 'Standard',
                'description' => 'A fast-paced combination of tennis and squash.',
                'price' => 2000,
                'capacity' => 4,
                'status' => 'Open',
                'minPlayers' => 2,
                'maxPlayers' => 4,
                'onPremisesOnly' => false,
                 'options' => json_encode([
                    [
                        'id' => 'court_time',
                        'label' => 'Court Time',
                        'type' => 'select',
                        'values' => [
                            ['id' => '60min', 'label' => '1 Hour', 'price' => 2000],
                            ['id' => '90min', 'label' => '1.5 Hours', 'price' => 3000],
                        ]
                    ],
                ]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];
DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        foreach ($games as $gameData) {
            DB::table('games')->updateOrInsert(
                ['name' => $gameData['name']],
                $gameData
            );
        }
    }
}
