<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;

class SystemController extends Controller
{
    /**
     * Run database migrations and seeders.
     *
     * @return \Illuminate\Http\JsonResponse
     */
 public function migrateAndSeed()
{
    try {
        // 1. Run Migrations
        // --force is required in production environments
        Artisan::call('migrate', ['--force' => true]);
        $migrationOutput = Artisan::output();

        // 2. Run the DatabaseSeeder
        // This triggers Database\Seeders\DatabaseSeeder::run()
        Artisan::call('db:seed', ['--force' => true]);
        $seedOutput = Artisan::output();

        return response()->json([
            'success' => true,
            'message' => 'System updated successfully.',
            'details' => [
                'migration' => $migrationOutput,
                'seeding' => $seedOutput
            ]
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => 'Process failed: ' . $e->getMessage(),
        ], 500);
    }
}
}