<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Game;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class GameController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(): JsonResponse
    {
        $games = Game::all();
        //- Fix: The frontend expects the game's name property to be 'gameName'.
        $transformedGames = $games->map(function ($game) {
            return [
                'id' => $game->id,
                'name' => $game->name, // Rename 'name' to 'gameName'
                'description' => $game->description,
                'price' => $game->price,
                'category' => $game->category,
                'minPlayers' => $game->minPlayers,
                'maxPlayers' => $game->maxPlayers,
                'status' => $game->status,
                'onPremisesOnly' => $game->onPremisesOnly,
                'capacity' => $game->capacity,
                'image_id' => $game->image_id,
                'options' => $game->options,
                'pricingOptions' => $game->pricingOptions,
                'timeSlots' => $game->timeSlots,
            ];
        });
        return response()->json($transformedGames);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  string  $id
     * @return \App\Models\Game
     */
    public function update(Request $request, string $id): Game
    {
        $game = Game::findOrFail($id);
        
        // The 'options' field from the frontend is an array.
        // We'll rely on the model's '$casts' property to handle JSON serialization.
        $game->update($request->all());
        
        // Return the updated model. It's good practice to fresh() it to get the latest state.
        return $game->fresh();
    }
}
